/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.drone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.client.model.entity.drone.ModelDrone;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DroneDigLaserLayer
extends RenderLayer<AbstractDroneEntity, ModelDrone> {
    private static final float LASER_SIZE = 0.4f;

    DroneDigLaserLayer(RenderLayerParent<AbstractDroneEntity, ModelDrone> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractDroneEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        BlockPos diggingPos = entityIn.getDugBlock();
        if (diggingPos != null) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStackIn.m_85837_(0.0, -1.0, 0.0);
            BlockState state = entityIn.m_20193_().m_8055_(diggingPos);
            VoxelShape shape = state.m_60808_((BlockGetter)entityIn.m_20193_(), diggingPos);
            if (shape.m_83281_()) {
                this.renderLaser(matrixStackIn, bufferIn, partialTicks, entityIn, 0.0, -entityIn.getLaserOffsetY(), 0.0, (double)diggingPos.m_123341_() + 0.5 - entityIn.m_20185_(), (double)diggingPos.m_123342_() + 0.45 - entityIn.m_20186_(), (double)diggingPos.m_123343_() + 0.5 - entityIn.m_20189_());
            } else {
                Vec3 vec = shape.m_83215_().m_82399_().m_82549_(Vec3.m_82528_((Vec3i)diggingPos));
                this.renderLaser(matrixStackIn, bufferIn, partialTicks, entityIn, 0.0, -entityIn.getLaserOffsetY(), 0.0, vec.m_7096_() - entityIn.m_20185_(), vec.m_7098_() - entityIn.m_20186_(), vec.m_7094_() - entityIn.m_20189_());
            }
            matrixStackIn.m_85849_();
        }
    }

    private void renderLaser(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, AbstractDroneEntity drone, double x1, double y1, double z1, double x2, double y2, double z2) {
        float laserLength = (float)PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        matrixStack.m_85836_();
        matrixStack.m_85837_(x1, y1, z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        double rotYawRad = Math.atan2(dx, dz);
        double rotPitchRad = 1.5707963267948966 - Math.atan2(dy, f3);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)rotYawRad));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122270_((float)rotPitchRad));
        matrixStack.m_85841_(0.4f, 0.4f, 0.4f);
        matrixStack.m_85837_(0.0, 0.6, 0.0);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)drone.f_19797_ + partialTicks));
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, laserLength / 0.4f * 2.0f, 1.0f);
        int[] cols = RenderUtils.decomposeColor(drone.getLaserColor());
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.m_6299_(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        posMat = matrixStack.m_85850_().m_85861_();
        builder = buffer.m_6299_(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START));
        this.renderQuad(posMat, builder, cols);
        builder = buffer.m_6299_(ModRenderTypes.getTextureRenderColored(Textures.RENDER_LASER_START_OVERLAY));
        this.renderQuad(posMat, builder, cols);
        matrixStack.m_85849_();
    }

    private void renderQuad(Matrix4f posMat, VertexConsumer builder, int[] cols) {
        builder.m_85982_(posMat, -0.5f, 0.0f, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, -0.5f, 1.0f, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, 0.5f, 1.0f, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(posMat, 0.5f, 0.0f, 0.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
    }
}

